#include <iostream>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<long long> a(n);
    for (long long& x : a) cin >> x;

    // Prefix sume
    vector<long long> prefix(n + 1, 0);
    unordered_map<long long, int> first, last;

    for (int i = 0; i < n; ++i)
        prefix[i + 1] = prefix[i] + a[i];

    for (int i = 0; i <= n; ++i) {
        if (!first.count(prefix[i]))
            first[prefix[i]] = i;
        last[prefix[i]] = i;
    }

    // Pozicije svakog broja u nizu
    unordered_map<long long, vector<int>> pos;
    for (int i = 0; i < n; ++i)
        pos[a[i]].push_back(i);

    int answer = 0;

    for (const auto& [sum, l] : first) {
        int r = last[sum];
        if (r - l <= 0) continue;

        // Pronadi sve unikatne vrednosti u segmentu [l, r)
        unordered_set<long long> unique;
        for (int k = l; k < r; ++k)
            unique.insert(a[k]);

        int maxFreq = 0;
//aaaajmoi binarnaaaaaaa
        for (long long x : unique) {
            auto lo = lower_bound(pos[x].begin(), pos[x].end(), l);
            auto hi = lower_bound(pos[x].begin(), pos[x].end(), r);
            int count = hi - lo;
            maxFreq = max(maxFreq, count);
        }

        answer = max(answer, maxFreq);
    }

    cout << answer << '\n';
    return 0;
}